function transforms = getHorizontalDistributionTransforms(volumes, spacing)
% function transforms] = getHorizontalDistributionTransforms(volumes)
% 
% Description:
% Function to obtain transforms that distribute volumes horizontally with a
% given spacing. The number of transforms obtained equals the number of
% volumes passed
% 
% Author: Johann Strasser
% Date: 070326

xDims = [];
totalWidth = 0;
% transforms = getHTTransform();

for i = 1:length(volumes)
    l = size(volumes(i).volume, 2);
    totalWidth = totalWidth + l * volumes(i).voxelSize(1);
    
    if i ~= length(volumes)
        totalWidth = totalWidth + spacing;
    end
    
    xDims = [xDims l];
    transforms(i) = getHTTransform();
    transforms(i).name = volumes(i).parentTransform;
end


offset = -totalWidth / 2;

for j = 1:length(transforms)
    offset = offset + xDims(j) * volumes(j).voxelSize(1) / 2;
    
    if j ~= 1
        offset = offset + spacing;
        offset = offset + xDims(j - 1) * volumes(j).voxelSize(1) / 2;
    end
    
    transforms(j).translation(1) = offset;
end
